/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.DownloadTask;

public class MovieSubtitleDownloadTask
extends DownloadTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSubtitleDownloadTask.class);
    private final Movie movie;
    private final String languageTag;
    private final Path videoFilePath;

    public MovieSubtitleDownloadTask(String url, Path videoFilePath, String languageTag, Movie movie) {
        super(url, movie.getPathNIO().resolve(FilenameUtils.getBaseName((String)videoFilePath.getFileName().toString()) + "." + languageTag));
        this.movie = movie;
        this.languageTag = languageTag;
        this.videoFilePath = videoFilePath;
    }

    @Override
    protected void doInBackground() {
        super.doInBackground();
        MediaFile mf = new MediaFile(this.file);
        Path old = mf.getFileAsPath();
        if (mf.getType() != MediaFileType.SUBTITLE) {
            String basename = FilenameUtils.getBaseName((String)this.videoFilePath.toString()) + "." + this.languageTag;
            try (FileInputStream fis = new FileInputStream(this.file.toFile());
                 ZipInputStream is = new ZipInputStream(fis);){
                byte[] buffer = new byte[1024];
                ZipEntry ze = is.getNextEntry();
                while (ze != null) {
                    String zipEntryFilename = ze.getName();
                    String extension = FilenameUtils.getExtension((String)zipEntryFilename).toLowerCase(Locale.ROOT);
                    if (!Globals.settings.getSubtitleFileType().contains("." + extension) && !"idx".equals(extension)) {
                        ze = is.getNextEntry();
                        continue;
                    }
                    Path destination = this.file.getParent().resolve(basename + "." + extension);
                    try (FileOutputStream os = new FileOutputStream(destination.toFile());){
                        int len;
                        while ((len = is.read(buffer)) > 0) {
                            os.write(buffer, 0, len);
                        }
                        mf = new MediaFile(destination);
                        break;
                    }
                }
                is.closeEntry();
            }
            catch (Exception e) {
                LOGGER.debug("could not extract subtitle: {}", (Object)e.getMessage());
            }
        }
        if (!old.equals(mf.getFileAsPath())) {
            Utils.deleteFileSafely(old);
        }
        mf.gatherMediaInformation();
        this.movie.removeFromMediaFiles(mf);
        this.movie.addToMediaFiles(mf);
        this.movie.saveToDb();
    }
}

