/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.ui.UTF8Control;

public class MovieSetMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetMissingArtworkDownloadTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<MovieSet> moviesToScrape;

    public MovieSetMissingArtworkDownloadTask(List<MovieSet> moviesToScrape) {
        super(BUNDLE.getString("task.missingartwork"));
        this.moviesToScrape = moviesToScrape;
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing movieset artwork");
        this.initThreadPool(3, "scrapeMissingMovieSetArtwork");
        this.start();
        for (MovieSet movieSet : this.moviesToScrape) {
            if (!MovieSetArtworkHelper.hasMissingArtwork(movieSet)) continue;
            this.submitTask(new Worker(movieSet));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done getting missing artwork");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private MovieList movieList;
        private MovieSet movieSet;

        public Worker(MovieSet movieSet) {
            this.movieSet = movieSet;
        }

        @Override
        public void run() {
            try {
                this.movieList = MovieList.getInstance();
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE_SET);
                options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
                for (Map.Entry<String, Object> entry : this.movieSet.getIds().entrySet()) {
                    options.setId(entry.getKey(), entry.getValue().toString());
                }
                options.setLanguage(LocaleUtils.toLocale((String)MovieModuleManager.SETTINGS.getScraperLanguage().getLanguage()));
                options.setCountry(MovieModuleManager.SETTINGS.getCertificationCountry());
                options.setFanartSize(MovieModuleManager.SETTINGS.getImageFanartSize());
                options.setPosterSize(MovieModuleManager.SETTINGS.getImagePosterSize());
                for (MediaScraper scraper : this.movieList.getDefaultArtworkScrapers()) {
                    IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)scraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(options));
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movieSet, "message.scrape.subtitlefailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException missingIdException) {}
                }
                if (!artwork.isEmpty()) {
                    MovieSetArtworkHelper.downloadMissingArtwork(this.movieSet, artwork);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

