/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.Comparator;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.scraper.entities.MediaTrailer;

public class MovieTrailer
extends AbstractModelObject
implements Comparable<MovieTrailer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieTrailer.class);
    @JsonProperty
    private String name = "";
    @JsonProperty
    private String url = "";
    @JsonProperty
    private String quality = "";
    @JsonProperty
    private String provider = "";
    @JsonProperty
    private Boolean inNfo = Boolean.FALSE;
    @JsonProperty
    private String date = "";

    public MovieTrailer() {
    }

    public MovieTrailer(MediaTrailer mediaTrailer) {
        if (mediaTrailer != null) {
            this.name = mediaTrailer.getName();
            this.url = mediaTrailer.getUrl();
            this.quality = mediaTrailer.getQuality();
            this.provider = mediaTrailer.getProvider();
            this.date = mediaTrailer.getDate();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newValue) {
        String oldValue = this.url;
        this.url = newValue;
        this.firePropertyChange("url", oldValue, newValue);
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String newValue) {
        String oldValue = this.quality;
        this.quality = newValue;
        this.firePropertyChange("quality", oldValue, newValue);
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String newValue) {
        String oldValue = this.provider;
        this.provider = newValue;
        this.firePropertyChange("provider", oldValue, newValue);
    }

    public Boolean getInNfo() {
        return this.inNfo;
    }

    public void setInNfo(Boolean newValue) {
        if (this.url.startsWith("file")) {
            newValue = false;
        }
        Boolean oldValue = this.inNfo;
        this.inNfo = newValue;
        this.firePropertyChange("inNfo", oldValue, newValue);
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String newValue) {
        String oldValue = this.date;
        this.date = newValue;
        this.firePropertyChange("date", oldValue, newValue);
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("propertyChangeSupport");
            }
        }.toString();
    }

    public boolean equals(Object mt2) {
        if (mt2 instanceof MovieTrailer) {
            return this.compareTo((MovieTrailer)mt2) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(MovieTrailer mt2) {
        return this.getUrl().compareTo(mt2.getUrl());
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public static class QualityComparator
    implements Comparator<MovieTrailer> {
        @Override
        public int compare(MovieTrailer o1, MovieTrailer o2) {
            int quality1 = 0;
            int quality2 = 0;
            try {
                quality1 = Integer.parseInt(o1.quality.replace("p", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                quality2 = Integer.parseInt(o2.quality.replace("p", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return quality2 - quality1;
        }
    }
}

