/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.w3c.dom.Element;

public class MovieToMpMovingPicturesConnector
extends MovieGenericXmlConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieToMpMovingPicturesConnector.class);

    public MovieToMpMovingPicturesConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void addOwnTags() {
    }

    @Override
    protected void addMpaa() {
        Element mpaa = this.document.createElement("mpaa");
        if (this.movie.getCertification() != null) {
            mpaa.setTextContent(CertificationStyle.formatCertification(this.movie.getCertification(), MovieModuleManager.SETTINGS.getCertificationStyle()));
        }
        this.root.appendChild(mpaa);
    }

    @Override
    protected void addCertification() {
    }

    @Override
    protected void addCountry() {
        Element country = this.document.createElement("country");
        List<String> countries = MovieNfoParser.split(this.movie.getCountry());
        country.setTextContent(StringUtils.join(countries, (String)", "));
        this.root.appendChild(country);
    }

    @Override
    protected void addStudios() {
        Element studio = this.document.createElement("studio");
        List<String> studios = MovieNfoParser.split(this.movie.getProductionCompany());
        studio.setTextContent(StringUtils.join(studios, (String)", "));
        this.root.appendChild(studio);
    }

    @Override
    protected void addCredits() {
        Element credits = this.document.createElement("credits");
        credits.setTextContent(this.movie.getWritersAsString());
        this.root.appendChild(credits);
    }

    @Override
    protected void addDirectors() {
        Element director = this.document.createElement("director");
        director.setTextContent(this.movie.getDirectorsAsString());
        this.root.appendChild(director);
    }

    @Override
    protected void addLanguages() {
        Locale uiLanguage = Locale.getDefault();
        ArrayList<String> languages = new ArrayList<String>();
        for (String langu : MovieNfoParser.split(this.movie.getSpokenLanguages())) {
            Locale locale = new Locale(langu = langu.trim());
            String languageLocalized = locale.getDisplayLanguage(uiLanguage);
            if (StringUtils.isNotBlank((CharSequence)languageLocalized) && !langu.equalsIgnoreCase(languageLocalized)) {
                languages.add(languageLocalized);
                continue;
            }
            languages.add(langu);
        }
        Element element = this.document.createElement("language");
        element.setTextContent(StringUtils.join(languages, (String)", "));
        this.root.appendChild(element);
    }
}

