/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.IMovieConnector;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MovieGenericXmlConnector
implements IMovieConnector {
    protected final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    protected final Movie movie;
    protected MovieNfoParser parser = null;
    protected Document document;
    protected Element root;

    public MovieGenericXmlConnector(Movie movie) {
        this.movie = movie;
    }

    protected abstract Logger getLogger();

    protected abstract void addOwnTags();

    @Override
    public void write(List<MovieNfoNaming> nfoNames) {
        if (!MovieModuleManager.SETTINGS.isWriteCleanNfo()) {
            for (MediaFile mf : this.movie.getMediaFiles(MediaFileType.NFO)) {
                try {
                    this.parser = MovieNfoParser.parseNfo(mf.getFileAsPath());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (MovieNfoNaming nfoNaming : nfoNames) {
            String nfoFilename = this.movie.getNfoFilename(nfoNaming);
            if (StringUtils.isBlank((CharSequence)nfoFilename)) continue;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.document = factory.newDocumentBuilder().newDocument();
                this.document.setXmlStandalone(true);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                this.document.appendChild(this.document.createComment("created on " + dat + " - tinyMediaManager " + Globals.settings.getVersion()));
                this.root = this.document.createElement("movie");
                this.document.appendChild(this.root);
                this.addTitle();
                this.addOriginaltitle();
                this.addSorttitle();
                this.addYear();
                this.addRating();
                this.addUserrating();
                this.addVotes();
                this.addSet();
                this.addOutline();
                this.addPlot();
                this.addTagline();
                this.addRuntime();
                this.addThumb();
                this.addFanart();
                this.addMpaa();
                this.addCertification();
                this.addId();
                this.addTmdbid();
                this.addIds();
                this.addCountry();
                this.addPremiered();
                this.addWatched();
                this.addPlaycount();
                this.addGenres();
                this.addStudios();
                this.addCredits();
                this.addDirectors();
                this.addTags();
                this.addActors();
                this.addProducers();
                this.addTrailer();
                this.addLanguages();
                this.addDateAdded();
                this.addOwnTags();
                this.addUnsupportedTags();
                this.addTinyMediaManagerTags();
                StringWriter out = new StringWriter();
                this.getTransformer().transform(new DOMSource(this.document), new StreamResult(out));
                String xml = ((Object)out).toString().replaceAll("(?<!\r)\n", "\r\n");
                Path f = this.movie.getPathNIO().resolve(nfoFilename);
                Utils.writeStringToFile(f, xml);
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                this.getLogger().error("write {}: {}", (Object)this.movie.getPathNIO().resolve(nfoFilename), (Object)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movie, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (!newNfos.isEmpty()) {
            this.movie.removeAllMediaFiles(MediaFileType.NFO);
            this.movie.addToMediaFiles(newNfos);
        }
    }

    protected void addTitle() {
        Element title = this.document.createElement("title");
        title.setTextContent(this.movie.getTitle());
        this.root.appendChild(title);
    }

    protected void addOriginaltitle() {
        Element originaltitle = this.document.createElement("originaltitle");
        originaltitle.setTextContent(this.movie.getOriginalTitle());
        this.root.appendChild(originaltitle);
    }

    protected void addSorttitle() {
        Element sorttitle = this.document.createElement("sorttitle");
        sorttitle.setTextContent(this.movie.getSortTitle());
        this.root.appendChild(sorttitle);
    }

    protected void addYear() {
        Element year = this.document.createElement("year");
        year.setTextContent(this.movie.getYear() == 0 ? "" : Integer.toString(this.movie.getYear()));
        this.root.appendChild(year);
    }

    protected void addRating() {
        Map<String, Rating> ratings = this.movie.getRatings();
        Rating mainRating = ratings.get(MovieModuleManager.SETTINGS.getPreferredRating());
        if (mainRating == null) {
            for (Rating r : ratings.values()) {
                if ("user".equals(r.getId())) continue;
                mainRating = r;
            }
        }
        if (mainRating == null) {
            mainRating = new Rating();
        }
        Float rating10 = mainRating.getMaxValue() > 0 ? Float.valueOf(mainRating.getRating() * 10.0f / (float)mainRating.getMaxValue()) : Float.valueOf(mainRating.getRating());
        Element rating = this.document.createElement("rating");
        rating.setTextContent(String.format(Locale.US, "%.1f", rating10));
        this.root.appendChild(rating);
    }

    protected void addUserrating() {
        Rating rating = this.movie.getRating("user");
        Float rating10 = rating.getMaxValue() > 0 ? Float.valueOf(rating.getRating() * 10.0f / (float)rating.getMaxValue()) : Float.valueOf(rating.getRating());
        Element UserRating = this.document.createElement("userrating");
        UserRating.setTextContent(String.format(Locale.US, "%.1f", rating10));
        this.root.appendChild(UserRating);
    }

    protected void addVotes() {
        Element votes = this.document.createElement("votes");
        votes.setTextContent(Integer.toString(this.movie.getRating().getVotes()));
        this.root.appendChild(votes);
    }

    protected void addSet() {
        Element set = this.document.createElement("set");
        set.setTextContent(this.movie.getMovieSetTitle());
        this.root.appendChild(set);
    }

    protected void addOutline() {
        Element outline = this.document.createElement("outline");
        outline.setTextContent(this.movie.getPlot());
        this.root.appendChild(outline);
    }

    protected void addPlot() {
        Element plot = this.document.createElement("plot");
        plot.setTextContent(this.movie.getPlot());
        this.root.appendChild(plot);
    }

    protected void addTagline() {
        Element tagline = this.document.createElement("tagline");
        tagline.setTextContent(this.movie.getTagline());
        this.root.appendChild(tagline);
    }

    protected void addRuntime() {
        Element runtime = this.document.createElement("runtime");
        runtime.setTextContent(Integer.toString(this.movie.getRuntime()));
        this.root.appendChild(runtime);
    }

    protected void addThumb() {
        Element thumb = this.document.createElement("thumb");
        thumb.setTextContent(this.movie.getArtworkUrl(MediaFileType.POSTER));
        this.root.appendChild(thumb);
    }

    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        fanart.setTextContent(this.movie.getArtworkUrl(MediaFileType.FANART));
        this.root.appendChild(fanart);
    }

    protected void addMpaa() {
        Element mpaa = this.document.createElement("mpaa");
        if (this.movie.getCertification() != null) {
            if (this.movie.getCertification().getCountry() == CountryCode.US) {
                mpaa.setTextContent(Certification.getMPAAString((Certification)this.movie.getCertification()));
            } else {
                mpaa.setTextContent(CertificationStyle.formatCertification(this.movie.getCertification(), MovieModuleManager.SETTINGS.getCertificationStyle()));
            }
        }
        this.root.appendChild(mpaa);
    }

    protected void addCertification() {
        Element certification = this.document.createElement("certification");
        if (this.movie.getCertification() != null) {
            certification.setTextContent(CertificationStyle.formatCertification(this.movie.getCertification(), MovieModuleManager.SETTINGS.getCertificationStyle()));
        }
        this.root.appendChild(certification);
    }

    protected void addId() {
        Element id = this.document.createElement("id");
        id.setTextContent(this.movie.getImdbId());
        this.root.appendChild(id);
    }

    protected void addTmdbid() {
        Element tmdbid = this.document.createElement("tmdbid");
        if (this.movie.getTmdbId() > 0) {
            tmdbid.setTextContent(Integer.toString(this.movie.getTmdbId()));
        }
        this.root.appendChild(tmdbid);
    }

    protected void addIds() {
        for (Map.Entry<String, Object> entry : this.movie.getIds().entrySet()) {
            Element uniqueid = this.document.createElement("uniqueid");
            uniqueid.setAttribute("type", entry.getKey());
            if ("imdb".equals(entry.getKey()) || this.movie.getIds().size() == 1) {
                uniqueid.setAttribute("default", "true");
            } else {
                uniqueid.setAttribute("default", "false");
            }
            uniqueid.setTextContent(entry.getValue().toString());
            this.root.appendChild(uniqueid);
        }
    }

    protected void addCountry() {
        String[] countries;
        for (String c : countries = this.movie.getCountry().split("\\s*[,\\/]\\s*")) {
            Element country = this.document.createElement("country");
            country.setTextContent(c);
            this.root.appendChild(country);
        }
    }

    protected void addPremiered() {
        Element premiered = this.document.createElement("premiered");
        if (this.movie.getReleaseDate() != null) {
            premiered.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(this.movie.getReleaseDate()));
        }
        this.root.appendChild(premiered);
    }

    protected void addDateAdded() {
        Element dateadded = this.document.createElement("dateadded");
        if (this.movie.getDateAdded() != null) {
            dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.movie.getDateAdded()));
        }
        this.root.appendChild(dateadded);
    }

    protected void addWatched() {
        Element watched = this.document.createElement("watched");
        watched.setTextContent(Boolean.toString(this.movie.isWatched()));
        this.root.appendChild(watched);
    }

    protected void addPlaycount() {
        Element playcount = this.document.createElement("playcount");
        if (this.movie.isWatched() && this.parser != null && this.parser.playcount > 0) {
            playcount.setTextContent(Integer.toString(this.parser.playcount));
        } else if (this.movie.isWatched()) {
            playcount.setTextContent("1");
        }
        this.root.appendChild(playcount);
    }

    protected void addGenres() {
        for (MediaGenres mediaGenre : this.movie.getGenres()) {
            Element genre = this.document.createElement("genre");
            genre.setTextContent(mediaGenre.getLocalizedName(MovieModuleManager.SETTINGS.getNfoLanguage().toLocale()));
            this.root.appendChild(genre);
        }
    }

    protected void addStudios() {
        String[] studios;
        for (String s : studios = this.movie.getProductionCompany().split("\\s*[,\\/]\\s*")) {
            Element studio = this.document.createElement("studio");
            studio.setTextContent(s);
            this.root.appendChild(studio);
        }
    }

    protected void addCredits() {
        for (Person writer : this.movie.getWriters()) {
            Element element = this.document.createElement("credits");
            element.setTextContent(writer.getName());
            this.root.appendChild(element);
        }
    }

    protected void addDirectors() {
        for (Person director : this.movie.getDirectors()) {
            Element element = this.document.createElement("director");
            element.setTextContent(director.getName());
            this.root.appendChild(element);
        }
    }

    protected void addTags() {
        for (String t : this.movie.getTags()) {
            Element tag = this.document.createElement("tag");
            tag.setTextContent(t);
            this.root.appendChild(tag);
        }
    }

    protected void addActors() {
        for (Person movieActor : this.movie.getActors()) {
            Element actor = this.document.createElement("actor");
            Element name = this.document.createElement("name");
            name.setTextContent(movieActor.getName());
            actor.appendChild(name);
            Element role = this.document.createElement("role");
            role.setTextContent(movieActor.getRole());
            actor.appendChild(role);
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(movieActor.getThumbUrl());
            actor.appendChild(thumb);
            Element profile = this.document.createElement("profile");
            profile.setTextContent(movieActor.getProfileUrl());
            actor.appendChild(profile);
            this.root.appendChild(actor);
        }
    }

    protected void addProducers() {
        for (Person movieProducer : this.movie.getProducers()) {
            Element producer = this.document.createElement("producer");
            Element name = this.document.createElement("name");
            name.setTextContent(movieProducer.getName());
            producer.appendChild(name);
            Element role = this.document.createElement("role");
            role.setTextContent(movieProducer.getRole());
            producer.appendChild(role);
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(movieProducer.getThumbUrl());
            producer.appendChild(thumb);
            this.root.appendChild(producer);
        }
    }

    protected void addLanguages() {
        Element languages = this.document.createElement("languages");
        languages.setTextContent(this.movie.getSpokenLanguages());
        this.root.appendChild(languages);
    }

    protected void addTrailer() {
        Element trailer = this.document.createElement("trailer");
        for (MovieTrailer movieTrailer : new ArrayList<MovieTrailer>(this.movie.getTrailer())) {
            if (!movieTrailer.getInNfo().booleanValue() || movieTrailer.getUrl().startsWith("file")) continue;
            trailer.setTextContent(movieTrailer.getUrl());
            break;
        }
        this.root.appendChild(trailer);
    }

    protected void addSource() {
        Element source = this.document.createElement("source");
        source.setTextContent(this.movie.getMediaSource().name());
        this.root.appendChild(source);
    }

    protected void addUnsupportedTags() {
        if (this.parser != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            for (String unsupportedString : this.parser.unsupportedElements) {
                try {
                    Document unsupported = factory.newDocumentBuilder().parse(new ByteArrayInputStream(unsupportedString.getBytes("UTF-8")));
                    this.root.appendChild(this.document.importNode(unsupported.getFirstChild(), true));
                }
                catch (Exception e) {
                    this.getLogger().error("import unsupported tags: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected void addTinyMediaManagerTags() {
        this.root.appendChild(this.document.createComment("tinyMediaManager meta data"));
        this.addSource();
        this.addEdition();
    }

    protected void addEdition() {
        Element edition = this.document.createElement("edition");
        edition.setTextContent(this.movie.getEdition().name());
        this.root.appendChild(edition);
    }

    protected Element getSingleElementByTag(String tag) {
        NodeList nodeList = this.document.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    protected Transformer getTransformer() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        transformer.setOutputProperty("http://www.oracle.com/xml/is-standalone", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }
}

