/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.UrlUtil;

public class MovieSetArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetArtworkHelper.class);
    private static final List<MediaFileType> SUPPORTED_ARTWORK_TYPES = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART);
    private static final String[] SUPPORTED_ARTWORK_FILETYPES = new String[]{"jpg", "png", "tbn"};

    public static void updateArtwork(MovieSet movieSet) {
        MovieSetArtworkHelper.findArtworkInArtworkFolder(movieSet);
        for (Movie movie : new ArrayList<Movie>(movieSet.getMovies())) {
            MovieSetArtworkHelper.findArtworkInMovieFolder(movieSet, movie);
        }
    }

    public static void renameArtwork(MovieSet movieSet) {
        String artworkFolder = MovieModuleManager.SETTINGS.getMovieSetArtworkFolder();
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() || StringUtils.isBlank((CharSequence)artworkFolder)) {
            return;
        }
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        for (MediaFile mf : movieSet.getMediaFiles()) {
            if (!mf.isGraphic() || !mf.getFile().getParent().endsWith(artworkFolder)) continue;
            try {
                String extension = FilenameUtils.getExtension((String)mf.getFilename());
                String artworkFileName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle()) + "-" + mf.getType().name().toLowerCase(Locale.ROOT) + "." + extension;
                Path artworkFile = Paths.get(artworkFolder, artworkFileName);
                Utils.moveFileSafe(mf.getFileAsPath(), artworkFile);
                movieSet.addToMediaFiles(new MediaFile(artworkFile));
                cleanup.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("could not rename movie set artwork: {}", (Object)e.getMessage());
            }
        }
        for (MediaFile mf : cleanup) {
            movieSet.removeFromMediaFiles(mf);
        }
    }

    private static void findArtworkInArtworkFolder(MovieSet movieSet) {
        String artworkFolder = MovieModuleManager.SETTINGS.getMovieSetArtworkFolder();
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() || StringUtils.isBlank((CharSequence)artworkFolder)) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                String artworkFileName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle()) + "-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                Path artworkFile = Paths.get(artworkFolder, artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                MediaFile mediaFile = new MediaFile(artworkFile, type);
                mediaFile.gatherMediaInformation();
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    private static void findArtworkInMovieFolder(MovieSet movieSet, Movie movie) {
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            if (!movieSet.getMediaFiles(type).isEmpty()) continue;
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                String artworkFileName = "movieset-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                Path artworkFile = movie.getPathNIO().resolve(artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                MediaFile mediaFile = new MediaFile(artworkFile, type);
                mediaFile.gatherMediaInformation();
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    public static void setArtwork(MovieSet movieSet, List<MediaArtwork> artwork) {
        artwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage()));
        MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.LOGO);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        movieSet.saveToDb();
    }

    private static void setBestPoster(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.SETTINGS.getImagePosterSize().getOrder();
        String preferredLanguage = MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage();
        MediaArtwork foundPoster = null;
        if (MovieModuleManager.SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
            if (foundPoster == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundPoster = art;
                    break;
                }
            }
        }
        if (foundPoster == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER || art.getSizeOrder() != preferredSizeOrder) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
                foundPoster = art;
                break;
            }
        }
        if (foundPoster != null) {
            movieSet.setArtworkUrl(foundPoster.getDefaultUrl(), MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.SETTINGS.getImageFanartSize().getOrder();
        String preferredLanguage = MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage();
        MediaArtwork foundfanart = null;
        if (MovieModuleManager.SETTINGS.isImageLanguagePriority()) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
            if (foundfanart == null) {
                int minOrder = preferredSizeOrder - 1;
                int maxOrder = preferredSizeOrder + 1;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals(preferredLanguage) || art.getSizeOrder() != minOrder && art.getSizeOrder() != maxOrder) continue;
                    foundfanart = art;
                    break;
                }
            }
        }
        if (foundfanart == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != preferredSizeOrder) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart == null) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND) continue;
                foundfanart = art;
                break;
            }
        }
        if (foundfanart != null) {
            movieSet.setArtworkUrl(foundfanart.getDefaultUrl(), MediaFileType.FANART);
        }
    }

    private static void setBestArtwork(MovieSet movieSet, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type) continue;
            movieSet.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            break;
        }
    }

    public static void downloadArtwork(MovieSet movieSet, MediaFileType type) {
        String url = movieSet.getArtworkUrl(type);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static void writeImagesToMovieFolder(MovieSet movieSet, List<Movie> movies) {
        if (!MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder()) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            String url = movieSet.getArtworkUrl(type);
            if (StringUtils.isBlank((CharSequence)url)) continue;
            MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type, movies);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
    }

    public static void cleanMovieSetArtworkInMovieFolder(Movie movie) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(movie.getPathNIO());){
            for (Path entry : stream) {
                Matcher matcher = MediaFile.MOVIESET_ARTWORK_PATTERN.matcher(entry.getFileName().toString());
                if (!matcher.find()) continue;
                Utils.deleteFileSafely(entry);
            }
        }
        catch (Exception e) {
            LOGGER.error("remove movie set artwork: {}", (Object)e.getMessage());
        }
    }

    public static boolean hasMissingArtwork(MovieSet movieSet) {
        if (!MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        return !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void downloadMissingArtwork(MovieSet movieSet) {
        MovieSetArtworkHelper.downloadMissingArtwork(movieSet, false);
    }

    public static void downloadMissingArtwork(MovieSet movieSet, boolean force) {
        MediaFileType[] mfts;
        for (MediaFileType mft : mfts = MediaFileType.getGraphicMediaFileTypes()) {
            List<MediaFile> mfs = movieSet.getMediaFiles(mft);
            if (!mfs.isEmpty()) continue;
            boolean download = false;
            switch (mft) {
                case FANART: {
                    if (MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case POSTER: {
                    if (MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case BANNER: {
                    if (MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARART: {
                    if (MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case DISC: {
                    if (MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case LOGO: {
                    if (MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARLOGO: {
                    if (MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case THUMB: {
                    if (MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case EXTRAFANART: {
                    if (!MovieModuleManager.SETTINGS.isImageExtraFanart() && !force) break;
                    download = true;
                    break;
                }
                case EXTRATHUMB: {
                    if (!MovieModuleManager.SETTINGS.isImageExtraThumbs() && !force) break;
                    download = true;
                    break;
                }
            }
            if (!download) continue;
            MovieSetArtworkHelper.downloadArtwork(movieSet, mft);
        }
    }

    public static void downloadMissingArtwork(MovieSet movieSet, List<MediaArtwork> artwork) {
        artwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(MovieModuleManager.SETTINGS.getScraperLanguage().getLanguage()));
        if (movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.LOGO);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        movieSet.saveToDb();
    }

    private static class MovieSetImageFetcherTask
    implements Runnable {
        private MovieSet movieSet;
        private String urlToArtwork;
        private MediaFileType type;
        private boolean writeToArtworkFolder;
        private String artworkFolder;
        private boolean writeToMovieFolder;
        private List<MediaFile> writtenArtworkFiles;
        private List<Movie> movies;

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.writtenArtworkFiles = new ArrayList<MediaFile>();
            this.movies = new ArrayList<Movie>(movieSet.getMovies());
            this.writeToMovieFolder = MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder();
            this.artworkFolder = MovieModuleManager.SETTINGS.getMovieSetArtworkFolder();
            this.writeToArtworkFolder = MovieModuleManager.SETTINGS.isEnableMovieSetArtworkFolder() && StringUtils.isNotBlank((CharSequence)this.artworkFolder);
        }

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type, List<Movie> movies) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.writtenArtworkFiles = new ArrayList<MediaFile>();
            this.movies = new ArrayList<Movie>(movies);
            this.writeToMovieFolder = MovieModuleManager.SETTINGS.isEnableMovieSetArtworkMovieFolder();
            this.artworkFolder = "";
            this.writeToArtworkFolder = false;
        }

        @Override
        public void run() {
            try {
                byte[] bytes = UrlUtil.getByteArrayFromUrl((String)this.urlToArtwork);
                String extension = FilenameUtils.getExtension((String)this.urlToArtwork);
                this.movieSet.removeAllMediaFiles(this.type);
                if (this.writeToArtworkFolder) {
                    this.writeImageToArtworkFolder(bytes, extension);
                }
                if (this.writeToMovieFolder) {
                    this.writeImageToMovieFolders(bytes, extension);
                }
                if (!this.writeToArtworkFolder && !this.writeToMovieFolder) {
                    this.writeImageToCacheFolder(bytes);
                }
                this.movieSet.addToMediaFiles(this.writtenArtworkFiles);
                this.movieSet.saveToDb();
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("fetch image: {} - {}", (Object)this.urlToArtwork, (Object)e.getMessage());
            }
        }

        private void writeImageToArtworkFolder(byte[] bytes, String extension) {
            Path artworkFolder = Paths.get(this.artworkFolder, new String[0]);
            if (!Files.exists(artworkFolder, new LinkOption[0])) {
                try {
                    Files.createDirectories(artworkFolder, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.warn("could not create directory: " + artworkFolder, (Throwable)e);
                }
            }
            try {
                String filename = MovieRenamer.replaceInvalidCharacters(this.movieSet.getTitle()) + "-";
                filename = filename + this.type.name().toLowerCase(Locale.ROOT) + "." + extension;
                Path imageFile = artworkFolder.resolve(filename);
                this.writeImage(bytes, imageFile);
                MediaFile artwork = new MediaFile(imageFile, this.type);
                artwork.gatherMediaInformation();
                this.writtenArtworkFiles.add(artwork);
                ImageCache.invalidateCachedImage(artwork);
                ImageCache.cacheImageSilently(artwork);
            }
            catch (Exception e) {
                LOGGER.warn("could not write file", (Throwable)e);
            }
        }

        private void writeImageToMovieFolders(byte[] bytes, String extension) {
            if (this.movies.isEmpty()) {
                return;
            }
            String filename = "movieset-" + this.type.name().toLowerCase(Locale.ROOT) + "." + extension;
            for (Movie movie : this.movies) {
                try {
                    if (movie.isMultiMovieDir()) continue;
                    Path imageFile = movie.getPathNIO().resolve(filename);
                    this.writeImage(bytes, imageFile);
                    MediaFile artwork = new MediaFile(imageFile, this.type);
                    artwork.gatherMediaInformation();
                    this.writtenArtworkFiles.add(artwork);
                    ImageCache.invalidateCachedImage(artwork);
                    ImageCache.cacheImageSilently(artwork);
                }
                catch (Exception e) {
                    LOGGER.warn("could not write files", (Throwable)e);
                }
            }
        }

        private void writeImageToCacheFolder(byte[] bytes) {
            String filename = ImageCache.getMD5WithSubfolder(this.urlToArtwork);
            try {
                this.writeImage(bytes, ImageCache.getCacheDir().resolve(filename + ".jpg"));
            }
            catch (Exception e) {
                LOGGER.warn("error in image fetcher", (Throwable)e);
            }
        }

        private void writeImage(byte[] bytes, Path pathAndFilename) throws IOException {
            FileOutputStream outputStream = new FileOutputStream(pathAndFilename.toFile());
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
            outputStream.flush();
            try {
                outputStream.getFD().sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
            outputStream.close();
            ((InputStream)is).close();
        }
    }
}

