/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.CustomNullStringSerializerProvider;
import org.tinymediamanager.core.ITmmModule;
import org.tinymediamanager.core.NullKeySerializer;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.UTF8Control;

public class MovieModuleManager
implements ITmmModule {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    public static final MovieSettings SETTINGS = MovieSettings.getInstance();
    private static final String MODULE_TITLE = "Movie management";
    private static final String MOVIE_DB = "movies.db";
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieModuleManager.class);
    private static MovieModuleManager instance;
    private boolean enabled = false;
    private MVStore mvStore;
    private ObjectWriter movieObjectWriter;
    private ObjectWriter movieSetObjectWriter;
    private MVMap<UUID, String> movieMap;
    private MVMap<UUID, String> movieSetMap;
    private List<String> startupMessages = new ArrayList<String>();

    private MovieModuleManager() {
    }

    public static MovieModuleManager getInstance() {
        if (instance == null) {
            instance = new MovieModuleManager();
        }
        return instance;
    }

    @Override
    public String getModuleTitle() {
        return MODULE_TITLE;
    }

    @Override
    public void startUp() {
        Path databaseFile = Paths.get(Globals.settings.getSettingsFolder(), MOVIE_DB);
        try {
            this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(4096).open();
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException && e.getMessage().contains("file is locked")) {
                throw e;
            }
            LOGGER.error("Could not open database file: {}", (Object)e.getMessage());
            LOGGER.info("starting over with an empty database file");
            try {
                Utils.deleteFileSafely(Paths.get("movies.db.corrupted", new String[0]));
                Utils.moveFileSafe(databaseFile, Paths.get("movies.db.corrupted", new String[0]));
                this.mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compressHigh().autoCommitBufferSize(4096).open();
                this.startupMessages.add(BUNDLE.getString("movie.loaddb.failed"));
            }
            catch (Exception e1) {
                LOGGER.error("could not move old database file and create a new one: {}", (Object)e1.getMessage());
            }
        }
        this.mvStore.setAutoCommitDelay(2000);
        this.mvStore.setRetentionTime(0);
        this.mvStore.setReuseSpace(true);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        objectMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        objectMapper.configure(MapperFeature.AUTO_DETECT_SETTERS, false);
        objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        objectMapper.setSerializerProvider((DefaultSerializerProvider)new CustomNullStringSerializerProvider());
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        this.movieObjectWriter = objectMapper.writerFor(Movie.class);
        this.movieSetObjectWriter = objectMapper.writerFor(MovieSet.class);
        this.movieMap = this.mvStore.openMap("movies");
        this.movieSetMap = this.mvStore.openMap("movieSets");
        MovieList.getInstance().loadMoviesFromDatabase(this.movieMap, objectMapper);
        MovieList.getInstance().loadMovieSetsFromDatabase(this.movieSetMap, objectMapper);
        MovieList.getInstance().initDataAfterLoading();
        this.enabled = true;
    }

    @Override
    public void shutDown() throws Exception {
        this.mvStore.compactMoveChunks();
        this.mvStore.close();
        this.enabled = false;
        if (Globals.settings.isDeleteTrashOnExit()) {
            for (String ds : SETTINGS.getMovieDataSource()) {
                Path file = Paths.get(ds, ".deletedByTMM");
                Utils.deleteDirectoryRecursive(file);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void dump(Movie movie) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object json = mapper.readValue((String)this.movieMap.get((Object)movie.getDbId()), Object.class);
            String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
            LOGGER.info("Dumping Movie: {}\n{}", (Object)movie.getDbId(), (Object)s);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse JSON!", (Throwable)e);
        }
    }

    public void dump(MovieSet movieSet) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object json = mapper.readValue((String)this.movieSetMap.get((Object)movieSet.getDbId()), Object.class);
            String s = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
            LOGGER.info("Dumping MovieSet: {}\n{}", (Object)movieSet.getDbId(), (Object)s);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse JSON!", (Throwable)e);
        }
    }

    void persistMovie(Movie movie) throws Exception {
        String oldValue;
        String newValue = this.movieObjectWriter.writeValueAsString((Object)movie);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.movieMap.get((Object)movie.getDbId())))) {
            this.movieMap.put((Object)movie.getDbId(), (Object)newValue);
        }
    }

    void removeMovieFromDb(Movie movie) {
        this.movieMap.remove((Object)movie.getDbId());
    }

    void persistMovieSet(MovieSet movieSet) throws Exception {
        String oldValue;
        String newValue = this.movieSetObjectWriter.writeValueAsString((Object)movieSet);
        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)(oldValue = (String)this.movieSetMap.get((Object)movieSet.getDbId())))) {
            this.movieSetMap.put((Object)movieSet.getDbId(), (Object)newValue);
        }
    }

    void removeMovieSetFromDb(MovieSet movieSet) {
        this.movieSetMap.remove((Object)movieSet.getDbId());
    }

    @Override
    public void initializeDatabase() {
        Utils.deleteFileSafely(Paths.get(Settings.getInstance().getSettingsFolder(), MOVIE_DB));
    }

    @Override
    public void saveSettings() {
        SETTINGS.saveSettings();
    }

    @Override
    public List<String> getStartupMessages() {
        return this.startupMessages;
    }
}

