/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieTrailerDownloadTask;
import org.tinymediamanager.core.movie.tasks.YoutubeDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;

public class MovieHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieHelpers.class);

    public static Certification parseCertificationStringForMovieSetupCountry(String name) {
        Certification cert = Certification.UNKNOWN;
        if ((name = name.trim()).contains("/")) {
            String[] cs;
            String[] countries;
            for (String c : countries = name.split("/")) {
                if ((c = c.trim()).contains(":")) {
                    cs = c.split(":");
                    cert = Certification.getCertification((CountryCode)MovieModuleManager.SETTINGS.getCertificationCountry(), (String)cs[1]);
                    if (cert == Certification.UNKNOWN) continue;
                    return cert;
                }
                cert = Certification.getCertification((CountryCode)MovieModuleManager.SETTINGS.getCertificationCountry(), (String)c);
                if (cert == Certification.UNKNOWN) continue;
                return cert;
            }
            for (String c : countries) {
                if (!((c = c.trim()).contains(":") ? (cert = Certification.findCertification((String)(cs = c.split(":"))[1])) != Certification.UNKNOWN : (cert = Certification.findCertification((String)c)) != Certification.UNKNOWN)) continue;
                return cert;
            }
        } else if (name.contains(":")) {
            String[] cs = name.split(":");
            cert = Certification.getCertification((CountryCode)MovieModuleManager.SETTINGS.getCertificationCountry(), (String)cs[1].trim());
        } else {
            cert = Certification.getCertification((CountryCode)MovieModuleManager.SETTINGS.getCertificationCountry(), (String)name.trim());
        }
        if (cert == Certification.UNKNOWN) {
            cert = Certification.findCertification((String)name);
        }
        return cert;
    }

    public static void startAutomaticTrailerDownload(Movie movie) {
        if (MovieModuleManager.SETTINGS.isUseTrailerPreference() && MovieModuleManager.SETTINGS.isAutomaticTrailerDownload() && movie.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !movie.getTrailer().isEmpty()) {
            MovieHelpers.selectTrailerProvider(movie, LOGGER);
        }
    }

    public static void selectTrailerProvider(Movie movie, Logger logger) {
        try {
            if (movie.getTrailer().get(0).getProvider().equalsIgnoreCase("youtube")) {
                YoutubeDownloadTask task = new YoutubeDownloadTask(movie.getTrailer().get(0), movie);
                TmmTaskManager.getInstance().addDownloadTask(task);
            } else {
                MovieTrailerDownloadTask task = new MovieTrailerDownloadTask(movie.getTrailer().get(0), movie);
                TmmTaskManager.getInstance().addDownloadTask(task);
            }
        }
        catch (Exception e) {
            logger.error("could not start trailer download: " + e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.movietrailerfailed", new String[]{":", e.getLocalizedMessage()}));
        }
    }
}

