/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieKeyartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieLogoNaming;
import org.tinymediamanager.core.movie.filenaming.MoviePosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieThumbNaming;
import org.tinymediamanager.core.movie.tasks.MovieExtraImageFetcherTask;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class MovieArtworkHelper {
    private MovieArtworkHelper() {
    }

    public static void downloadArtwork(Movie movie, MediaFileType type) {
        if (type == MediaFileType.EXTRAFANART || type == MediaFileType.EXTRATHUMB) {
            MovieArtworkHelper.downloadExtraArtwork(movie, type);
            return;
        }
        String url = movie.getArtworkUrl(type);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        ArrayList<Enum> fileNamings = new ArrayList<Enum>();
        switch (type) {
            case FANART: {
                fileNamings.addAll(MovieArtworkHelper.getFanartNamesForMovie(movie));
                break;
            }
            case POSTER: {
                fileNamings.addAll(MovieArtworkHelper.getPosterNamesForMovie(movie));
                break;
            }
            case LOGO: {
                fileNamings.addAll(MovieArtworkHelper.getLogoNamesForMovie(movie));
                break;
            }
            case CLEARLOGO: {
                fileNamings.addAll(MovieArtworkHelper.getClearlogoNamesForMovie(movie));
                break;
            }
            case BANNER: {
                fileNamings.addAll(MovieArtworkHelper.getBannerNamesForMovie(movie));
                break;
            }
            case CLEARART: {
                fileNamings.addAll(MovieArtworkHelper.getClearartNamesForMovie(movie));
                break;
            }
            case THUMB: {
                fileNamings.addAll(MovieArtworkHelper.getThumbNamesForMovie(movie));
                break;
            }
            case DISC: {
                fileNamings.addAll(MovieArtworkHelper.getDiscartNamesForMovie(movie));
                break;
            }
            case KEYART: {
                fileNamings.addAll(MovieArtworkHelper.getKeyartNamesForMovie(movie));
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        for (IFileNaming iFileNaming : fileNamings) {
            boolean firstImage = false;
            String filename = MovieArtworkHelper.getArtworkFilename(movie, iFileNaming, Utils.getArtworkExtension(url));
            if (StringUtils.isBlank((CharSequence)filename)) continue;
            if (++i == 1) {
                firstImage = true;
            }
            MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(movie, url, MediaFileType.getMediaArtworkType(type), filename, firstImage);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        if (url.startsWith("file:")) {
            movie.removeArtworkUrl(type);
        }
    }

    public static void downloadMissingArtwork(Movie movie) {
        MovieArtworkHelper.downloadMissingArtwork(movie, false);
    }

    public static void downloadMissingArtwork(Movie movie, boolean force) {
        MediaFileType[] mfts;
        for (MediaFileType mft : mfts = MediaFileType.getGraphicMediaFileTypes()) {
            List<MediaFile> mfs = movie.getMediaFiles(mft);
            if (!mfs.isEmpty()) continue;
            boolean download = false;
            switch (mft) {
                case FANART: {
                    if (MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case POSTER: {
                    if (MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case BANNER: {
                    if (MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARART: {
                    if (MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case DISC: {
                    if (MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case LOGO: {
                    if (MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARLOGO: {
                    if (MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case THUMB: {
                    if (MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case KEYART: {
                    if (MovieModuleManager.SETTINGS.getKeyartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case EXTRAFANART: {
                    if (!MovieModuleManager.SETTINGS.isImageExtraFanart() && !force) break;
                    download = true;
                    break;
                }
                case EXTRATHUMB: {
                    if (!MovieModuleManager.SETTINGS.isImageExtraThumbs() && !force) break;
                    download = true;
                    break;
                }
            }
            if (!download) continue;
            MovieArtworkHelper.downloadArtwork(movie, mft);
        }
    }

    public static void downloadMissingArtwork(Movie movie, List<MediaArtwork> artwork) {
        artwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage()));
        if (movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieArtworkHelper.setBestPoster(movie, artwork);
        }
        if (movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieArtworkHelper.setBestFanart(movie, artwork);
        }
        if (movie.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.LOGO, !MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty());
        }
        if (movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, !MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty());
        }
        if (movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, !MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty());
        }
        if (movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, !MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty());
        }
        if (movie.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty());
        }
        if (movie.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, !MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty());
        }
        if (movie.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.KEYART, !MovieModuleManager.SETTINGS.getKeyartFilenames().isEmpty());
        }
        ArrayList<String> extrathumbs = new ArrayList<String>();
        if (movie.getMediaFiles(MediaFileType.EXTRATHUMB).isEmpty() && MovieModuleManager.SETTINGS.isImageExtraThumbs() && MovieModuleManager.SETTINGS.getImageExtraThumbsCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.SETTINGS.getImageFanartSize().getOrder()) continue;
                extrathumbs.add(art.getDefaultUrl());
                if (extrathumbs.size() < MovieModuleManager.SETTINGS.getImageExtraThumbsCount()) continue;
                break;
            }
            movie.setExtraThumbs(extrathumbs);
            if (!extrathumbs.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
            }
        }
        ArrayList<String> extrafanarts = new ArrayList<String>();
        if (MovieModuleManager.SETTINGS.isImageExtraFanart() && MovieModuleManager.SETTINGS.getImageExtraFanartCount() > 0) {
            for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || art.getSizeOrder() != MovieModuleManager.SETTINGS.getImageFanartSize().getOrder()) continue;
                extrafanarts.add(art.getDefaultUrl());
                if (extrafanarts.size() < MovieModuleManager.SETTINGS.getImageExtraFanartCount()) continue;
                break;
            }
            movie.setExtraFanarts(extrafanarts);
            if (!extrafanarts.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
            }
        }
        movie.saveToDb();
    }

    public static boolean hasMissingArtwork(Movie movie) {
        if (!MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.LOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            return true;
        }
        return !MovieModuleManager.SETTINGS.getKeyartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.KEYART).isEmpty();
    }

    public static String getArtworkFilename(Movie movie, IFileNaming fileNaming, String extension) {
        List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && !mfs.isEmpty()) {
            return fileNaming.getFilename(movie.getVideoBasenameWithoutStacking(), extension);
        }
        return fileNaming.getFilename("", extension);
    }

    public static List<MovieFanartNaming> getFanartNamesForMovie(Movie movie) {
        List<MovieFanartNaming> fanartnames = new ArrayList<MovieFanartNaming>();
        if (MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty()) {
            return fanartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getFanartFilenames().contains(MovieFanartNaming.FILENAME_FANART)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART);
            }
            if (MovieModuleManager.SETTINGS.getFanartFilenames().contains(MovieFanartNaming.FILENAME_FANART2)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART2);
            }
            if (fanartnames.isEmpty() || !MovieModuleManager.SETTINGS.getFanartFilenames().isEmpty()) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART);
            }
        } else if (movie.isDisc()) {
            fanartnames.add(MovieFanartNaming.FANART);
        } else {
            fanartnames = MovieModuleManager.SETTINGS.getFanartFilenames();
        }
        return fanartnames;
    }

    public static List<MoviePosterNaming> getPosterNamesForMovie(Movie movie) {
        ArrayList<MoviePosterNaming> posternames = new ArrayList<MoviePosterNaming>();
        if (MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty()) {
            return posternames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getPosterFilenames().contains(MoviePosterNaming.FILENAME_POSTER)) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER);
            }
            if (MovieModuleManager.SETTINGS.getPosterFilenames().contains(MoviePosterNaming.FILENAME)) {
                posternames.add(MoviePosterNaming.FILENAME);
            }
            if (posternames.isEmpty() && !MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty()) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getPosterFilenames().contains(MoviePosterNaming.FOLDER)) {
                posternames.add(MoviePosterNaming.FOLDER);
            }
            if (MovieModuleManager.SETTINGS.getPosterFilenames().contains(MoviePosterNaming.POSTER) || posternames.isEmpty() && !MovieModuleManager.SETTINGS.getPosterFilenames().isEmpty()) {
                posternames.add(MoviePosterNaming.POSTER);
            }
        } else {
            posternames.addAll(MovieModuleManager.SETTINGS.getPosterFilenames());
        }
        return posternames;
    }

    public static List<MovieBannerNaming> getBannerNamesForMovie(Movie movie) {
        ArrayList<MovieBannerNaming> bannernames = new ArrayList<MovieBannerNaming>();
        if (MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty()) {
            return bannernames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getBannerFilenames().contains(MovieBannerNaming.FILENAME_BANNER)) {
                bannernames.add(MovieBannerNaming.FILENAME_BANNER);
            }
            if (bannernames.isEmpty() && !MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty()) {
                bannernames.add(MovieBannerNaming.FILENAME_BANNER);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getBannerFilenames().contains(MovieBannerNaming.BANNER)) {
                bannernames.add(MovieBannerNaming.BANNER);
            }
            if (bannernames.isEmpty() && !MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty()) {
                bannernames.add(MovieBannerNaming.BANNER);
            }
        } else {
            bannernames.addAll(MovieModuleManager.SETTINGS.getBannerFilenames());
        }
        return bannernames;
    }

    public static List<MovieClearartNaming> getClearartNamesForMovie(Movie movie) {
        ArrayList<MovieClearartNaming> clearartnames = new ArrayList<MovieClearartNaming>();
        if (MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty()) {
            return clearartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getClearartFilenames().contains(MovieClearartNaming.FILENAME_CLEARART)) {
                clearartnames.add(MovieClearartNaming.FILENAME_CLEARART);
            }
            if (clearartnames.isEmpty() && !MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty()) {
                clearartnames.add(MovieClearartNaming.FILENAME_CLEARART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getClearartFilenames().contains(MovieClearartNaming.CLEARART)) {
                clearartnames.add(MovieClearartNaming.CLEARART);
            }
            if (clearartnames.isEmpty() && !MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty()) {
                clearartnames.add(MovieClearartNaming.CLEARART);
            }
        } else {
            clearartnames.addAll(MovieModuleManager.SETTINGS.getClearartFilenames());
        }
        return clearartnames;
    }

    public static List<MovieDiscartNaming> getDiscartNamesForMovie(Movie movie) {
        ArrayList<MovieDiscartNaming> discartnames = new ArrayList<MovieDiscartNaming>();
        if (MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty()) {
            return discartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISC)) {
                discartnames.add(MovieDiscartNaming.FILENAME_DISC);
            }
            if (discartnames.isEmpty() && !MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty()) {
                discartnames.add(MovieDiscartNaming.FILENAME_DISC);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getDiscartFilenames().contains(MovieDiscartNaming.DISC)) {
                discartnames.add(MovieDiscartNaming.DISC);
            }
            if (discartnames.isEmpty() && !MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty()) {
                discartnames.add(MovieDiscartNaming.DISC);
            }
        } else {
            discartnames.addAll(MovieModuleManager.SETTINGS.getDiscartFilenames());
        }
        return discartnames;
    }

    public static List<MovieKeyartNaming> getKeyartNamesForMovie(Movie movie) {
        ArrayList<MovieKeyartNaming> keyartnames = new ArrayList<MovieKeyartNaming>();
        if (MovieModuleManager.SETTINGS.getKeyartFilenames().isEmpty()) {
            return keyartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getKeyartFilenames().contains(MovieKeyartNaming.FILENAME_KEYART)) {
                keyartnames.add(MovieKeyartNaming.FILENAME_KEYART);
            }
            if (keyartnames.isEmpty() && !MovieModuleManager.SETTINGS.getKeyartFilenames().isEmpty()) {
                keyartnames.add(MovieKeyartNaming.FILENAME_KEYART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getKeyartFilenames().contains(MovieKeyartNaming.KEYART)) {
                keyartnames.add(MovieKeyartNaming.KEYART);
            }
            if (keyartnames.isEmpty() && !MovieModuleManager.SETTINGS.getKeyartFilenames().isEmpty()) {
                keyartnames.add(MovieKeyartNaming.KEYART);
            }
        } else {
            keyartnames.addAll(MovieModuleManager.SETTINGS.getKeyartFilenames());
        }
        return keyartnames;
    }

    public static List<MovieLogoNaming> getLogoNamesForMovie(Movie movie) {
        ArrayList<MovieLogoNaming> logonames = new ArrayList<MovieLogoNaming>();
        if (MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty()) {
            return logonames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getLogoFilenames().contains(MovieLogoNaming.FILENAME_LOGO)) {
                logonames.add(MovieLogoNaming.FILENAME_LOGO);
            }
            if (logonames.isEmpty() && !MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty()) {
                logonames.add(MovieLogoNaming.FILENAME_LOGO);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getLogoFilenames().contains(MovieLogoNaming.LOGO)) {
                logonames.add(MovieLogoNaming.LOGO);
            }
            if (logonames.isEmpty() && !MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty()) {
                logonames.add(MovieLogoNaming.LOGO);
            }
        } else {
            logonames.addAll(MovieModuleManager.SETTINGS.getLogoFilenames());
        }
        return logonames;
    }

    public static List<MovieClearlogoNaming> getClearlogoNamesForMovie(Movie movie) {
        ArrayList<MovieClearlogoNaming> clearlogonames = new ArrayList<MovieClearlogoNaming>();
        if (MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty()) {
            return clearlogonames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getClearlogoFilenames().contains(MovieClearlogoNaming.FILENAME_CLEARLOGO)) {
                clearlogonames.add(MovieClearlogoNaming.FILENAME_CLEARLOGO);
            }
            if (clearlogonames.isEmpty() && !MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty()) {
                clearlogonames.add(MovieClearlogoNaming.FILENAME_CLEARLOGO);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getClearlogoFilenames().contains(MovieClearlogoNaming.CLEARLOGO)) {
                clearlogonames.add(MovieClearlogoNaming.CLEARLOGO);
            }
            if (clearlogonames.isEmpty() && !MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty()) {
                clearlogonames.add(MovieClearlogoNaming.CLEARLOGO);
            }
        } else {
            clearlogonames.addAll(MovieModuleManager.SETTINGS.getClearlogoFilenames());
        }
        return clearlogonames;
    }

    public static List<MovieThumbNaming> getThumbNamesForMovie(Movie movie) {
        ArrayList<MovieThumbNaming> thumbnames = new ArrayList<MovieThumbNaming>();
        if (MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty()) {
            return thumbnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.SETTINGS.getThumbFilenames().contains(MovieThumbNaming.FILENAME_THUMB)) {
                thumbnames.add(MovieThumbNaming.FILENAME_THUMB);
            }
            if (MovieModuleManager.SETTINGS.getThumbFilenames().contains(MovieThumbNaming.FILENAME_LANDSCAPE)) {
                thumbnames.add(MovieThumbNaming.FILENAME_LANDSCAPE);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty() && MovieModuleManager.SETTINGS.getThumbFilenames().contains(MovieThumbNaming.THUMB)) {
                thumbnames.add(MovieThumbNaming.FILENAME_THUMB);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty()) {
                thumbnames.add(MovieThumbNaming.FILENAME_LANDSCAPE);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.SETTINGS.getThumbFilenames().contains(MovieThumbNaming.THUMB)) {
                thumbnames.add(MovieThumbNaming.THUMB);
            }
            if (MovieModuleManager.SETTINGS.getThumbFilenames().contains(MovieThumbNaming.LANDSCAPE)) {
                thumbnames.add(MovieThumbNaming.LANDSCAPE);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty() && MovieModuleManager.SETTINGS.getThumbFilenames().contains(MovieThumbNaming.FILENAME_THUMB)) {
                thumbnames.add(MovieThumbNaming.THUMB);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty()) {
                thumbnames.add(MovieThumbNaming.LANDSCAPE);
            }
        } else {
            thumbnames.addAll(MovieModuleManager.SETTINGS.getThumbFilenames());
        }
        return thumbnames;
    }

    private static void downloadExtraArtwork(Movie movie, MediaFileType type) {
        MovieExtraImageFetcherTask task = new MovieExtraImageFetcherTask(movie, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static void setArtwork(Movie movie, List<MediaArtwork> artwork) {
        artwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage()));
        MovieArtworkHelper.setBestPoster(movie, artwork);
        MovieArtworkHelper.setBestFanart(movie, artwork);
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.LOGO, !MovieModuleManager.SETTINGS.getLogoFilenames().isEmpty());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, !MovieModuleManager.SETTINGS.getClearlogoFilenames().isEmpty());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, !MovieModuleManager.SETTINGS.getClearartFilenames().isEmpty());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, !MovieModuleManager.SETTINGS.getBannerFilenames().isEmpty());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, !MovieModuleManager.SETTINGS.getThumbFilenames().isEmpty());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, !MovieModuleManager.SETTINGS.getDiscartFilenames().isEmpty());
        MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.KEYART, !MovieModuleManager.SETTINGS.getKeyartFilenames().isEmpty());
        ArrayList<String> extrathumbs = new ArrayList<String>();
        if (MovieModuleManager.SETTINGS.isImageExtraThumbs() && MovieModuleManager.SETTINGS.getImageExtraThumbsCount() > 0) {
            List<MediaArtwork> sortedFanarts = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, MovieModuleManager.SETTINGS.getImageFanartSize().getOrder(), MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage());
            for (MediaArtwork art : sortedFanarts) {
                extrathumbs.add(art.getDefaultUrl());
                if (extrathumbs.size() < MovieModuleManager.SETTINGS.getImageExtraThumbsCount()) continue;
                break;
            }
            movie.setExtraThumbs(extrathumbs);
            if (!extrathumbs.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
            }
        }
        ArrayList<String> extrafanarts = new ArrayList<String>();
        if (MovieModuleManager.SETTINGS.isImageExtraFanart() && MovieModuleManager.SETTINGS.getImageExtraFanartCount() > 0) {
            List<MediaArtwork> sortedFanarts = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, MovieModuleManager.SETTINGS.getImageFanartSize().getOrder(), MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage());
            for (MediaArtwork art : sortedFanarts) {
                extrafanarts.add(art.getDefaultUrl());
                if (extrafanarts.size() < MovieModuleManager.SETTINGS.getImageExtraFanartCount()) continue;
                break;
            }
            movie.setExtraFanarts(extrafanarts);
            if (!extrafanarts.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
            }
        }
        movie.saveToDb();
        movie.writeNFO();
    }

    private static void setBestPoster(Movie movie, List<MediaArtwork> artwork) {
        String preferredLanguage;
        int preferredSizeOrder = MovieModuleManager.SETTINGS.getImagePosterSize().getOrder();
        List<MediaArtwork> sortedPosters = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder, preferredLanguage = MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage());
        if (!sortedPosters.isEmpty()) {
            MediaArtwork foundPoster = sortedPosters.get(0);
            movie.setArtworkUrl(foundPoster.getDefaultUrl(), MediaFileType.POSTER);
            if (movie.getTmdbId() == 0 && foundPoster.getTmdbId() > 0) {
                movie.setTmdbId(foundPoster.getTmdbId());
            }
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(Movie movie, List<MediaArtwork> artwork) {
        String preferredLanguage;
        int preferredSizeOrder = MovieModuleManager.SETTINGS.getImageFanartSize().getOrder();
        List<MediaArtwork> sortedFanarts = MovieArtworkHelper.sortArtwork(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder, preferredLanguage = MovieModuleManager.SETTINGS.getImageScraperLanguage().getLanguage());
        if (!sortedFanarts.isEmpty()) {
            MediaArtwork foundfanart = sortedFanarts.get(0);
            movie.setArtworkUrl(foundfanart.getDefaultUrl(), MediaFileType.FANART);
            if (movie.getTmdbId() == 0 && foundfanart.getTmdbId() > 0) {
                movie.setTmdbId(foundfanart.getTmdbId());
            }
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.FANART);
        }
    }

    private static List<MediaArtwork> sortArtwork(List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, int sizeOrder, String language) {
        ArrayList<MediaArtwork> sortedArtwork = new ArrayList<MediaArtwork>();
        for (MediaArtwork art : artwork) {
            if (sortedArtwork.contains(art) || art.getType() != type || !art.getLanguage().equals(language) || art.getSizeOrder() != sizeOrder) continue;
            sortedArtwork.add(art);
        }
        if (MovieModuleManager.SETTINGS.isImageLanguagePriority()) {
            int newOrder = sizeOrder;
            for (int counter = 1; counter <= 2; ++counter) {
                newOrder /= 2;
                for (MediaArtwork art : artwork) {
                    if (art.getType() != type || !art.getLanguage().equals(language) || art.getSizeOrder() != newOrder) continue;
                    sortedArtwork.add(art);
                }
            }
        }
        for (MediaArtwork art : artwork) {
            if (sortedArtwork.contains(art) || art.getType() != type || art.getSizeOrder() != sizeOrder) continue;
            sortedArtwork.add(art);
        }
        int newOrder = sizeOrder;
        for (int counter = 1; counter <= 2; ++counter) {
            newOrder /= 2;
            for (MediaArtwork art : artwork) {
                if (sortedArtwork.contains(art) || art.getType() != type || art.getSizeOrder() != newOrder) continue;
                sortedArtwork.add(art);
            }
        }
        if (sortedArtwork.isEmpty() && !artwork.isEmpty()) {
            for (MediaArtwork art : artwork) {
                if (sortedArtwork.contains(art) || art.getType() != type) continue;
                sortedArtwork.add(art);
            }
        }
        return sortedArtwork;
    }

    private static void setBestArtwork(Movie movie, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, boolean download) {
        for (MediaArtwork art : artwork) {
            if (art.getType() != type || !StringUtils.isNotBlank((CharSequence)art.getDefaultUrl())) continue;
            movie.setArtworkUrl(art.getDefaultUrl(), MediaFileType.getMediaFileType(type));
            if (!download) break;
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.getMediaFileType(type));
            break;
        }
    }
}

