/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.tinymediamanager.scraper.entities.MediaRating;

public class Rating {
    public static final String NFO = "NFO";
    public static final String DEFAULT = "default";
    public static final String USER = "user";
    @JsonProperty
    private String id = "";
    @JsonProperty
    private float rating = 0.0f;
    @JsonProperty
    private int votes = 0;
    @JsonProperty
    private int maxValue = 10;

    public Rating() {
    }

    public Rating(MediaRating mediaRating) {
        this.id = mediaRating.getId();
        this.rating = mediaRating.getRating();
        this.votes = mediaRating.getVoteCount();
        this.maxValue = mediaRating.getMaxValue();
    }

    public Rating(Rating source) {
        this(source.id, source.rating, source.votes, source.maxValue);
    }

    public Rating(String id, float rating) {
        this.id = id;
        this.rating = rating;
    }

    public Rating(String id, float rating, int votes) {
        this.id = id;
        this.rating = rating;
        this.votes = votes;
    }

    public Rating(String id, float rating, int votes, int maxValue) {
        this.id = id;
        this.rating = rating;
        this.votes = votes;
        if (maxValue > 0) {
            this.maxValue = maxValue;
        }
    }

    public Rating(String id, double rating, int votes, int maxValue) {
        this.id = id;
        this.rating = (float)rating;
        this.votes = votes;
        if (maxValue > 0) {
            this.maxValue = maxValue;
        }
    }

    public String getId() {
        return this.id;
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public float getRatingNormalized() {
        if (this.maxValue != 0) {
            return this.rating / (float)this.maxValue * 10.0f;
        }
        return 0.0f;
    }

    public void setRatingNormalized(float rating) {
        if (rating < 0.0f || rating > 10.0f) {
            return;
        }
        this.rating = rating;
        this.maxValue = 10;
    }
}

