/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Dimension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public abstract class MediaEntity
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaEntity.class);
    protected UUID dbId = UUID.randomUUID();
    @JsonProperty
    protected String dataSource = "";
    @JsonProperty
    protected Map<String, Object> ids = new ConcurrentHashMap<String, Object>(0);
    @JsonProperty
    protected String title = "";
    @JsonProperty
    protected String originalTitle = "";
    @JsonProperty
    protected int year = 0;
    @JsonProperty
    protected String plot = "";
    @JsonProperty
    protected String path = "";
    @JsonProperty
    protected Date dateAdded = new Date();
    @JsonProperty
    protected String productionCompany = "";
    @JsonProperty
    protected boolean scraped = false;
    @JsonProperty
    protected String note = "";
    @JsonProperty
    protected Map<String, Rating> ratings = new ConcurrentHashMap<String, Rating>(0);
    @JsonProperty
    private List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    @JsonProperty
    protected Map<MediaFileType, String> artworkUrlMap = new HashMap<MediaFileType, String>();
    protected boolean newlyAdded = false;
    protected boolean duplicate = false;
    protected ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public void merge(MediaEntity other) {
        this.merge(other, false);
    }

    public void forceMerge(MediaEntity other) {
        this.merge(other, true);
    }

    protected void merge(MediaEntity other, boolean force) {
        if (other == null) {
            return;
        }
        this.setTitle(StringUtils.isEmpty((CharSequence)this.title) || force ? other.title : this.title);
        this.setOriginalTitle(StringUtils.isEmpty((CharSequence)this.originalTitle) || force ? other.originalTitle : this.originalTitle);
        this.setYear(this.year == 0 || force ? other.year : this.year);
        this.setPlot(StringUtils.isEmpty((CharSequence)this.plot) || force ? other.plot : this.plot);
        this.setProductionCompany(StringUtils.isEmpty((CharSequence)this.productionCompany) || force ? other.productionCompany : this.productionCompany);
        if (force) {
            this.ids.clear();
            this.ratings.clear();
            this.artworkUrlMap.clear();
        }
        this.setRatings(other.ratings);
        for (String string : other.getIds().keySet()) {
            if (this.ids.containsKey(string)) continue;
            this.ids.put(string, other.getId(string));
        }
        for (MediaFileType mediaFileType : other.getArtworkUrls().keySet()) {
            if (this.artworkUrlMap.containsKey((Object)mediaFileType)) continue;
            this.artworkUrlMap.put(mediaFileType, other.getArtworkUrl(mediaFileType));
        }
    }

    public void initializeAfterLoading() {
        this.sortMediaFiles();
    }

    protected void sortMediaFiles() {
        Comparator<MediaFile> mediaFileComparator = this.getMediaFileComparator();
        if (mediaFileComparator != null) {
            this.mediaFiles.sort(mediaFileComparator);
        } else {
            Collections.sort(this.mediaFiles);
        }
    }

    public UUID getDbId() {
        return this.dbId;
    }

    public void setDbId(UUID id) {
        this.dbId = id;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String newValue) {
        String oldValue = this.dataSource;
        this.dataSource = newValue;
        this.firePropertyChange("dataSource", oldValue, newValue);
    }

    public Map<String, Object> getIds() {
        return this.ids;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getPlot() {
        return this.plot;
    }

    public String getPath() {
        return this.path;
    }

    public Path getPathNIO() {
        if (StringUtils.isBlank((CharSequence)this.path)) {
            return null;
        }
        return Paths.get(this.path, new String[0]).toAbsolutePath();
    }

    public String getParent() {
        Path path = this.getPathNIO();
        if (path == null) {
            return "";
        }
        Path parent = Paths.get(this.dataSource, new String[0]).toAbsolutePath().relativize(path.getParent());
        return parent.toString();
    }

    public Dimension getArtworkDimension(MediaFileType type) {
        List<MediaFile> artworks = this.getMediaFiles(type);
        if (!artworks.isEmpty()) {
            MediaFile mediaFile = artworks.get(0);
            return new Dimension(mediaFile.getVideoWidth(), mediaFile.getVideoHeight());
        }
        return new Dimension(0, 0);
    }

    public String getArtworkFilename(MediaFileType type) {
        List<MediaFile> artworks = this.getMediaFiles(type);
        if (!artworks.isEmpty()) {
            return artworks.get(0).getFile().toString();
        }
        return "";
    }

    public Map<String, Rating> getRatings() {
        return this.ratings;
    }

    public Rating getRating(String id) {
        return this.ratings.getOrDefault(id, new Rating());
    }

    public Rating getRating() {
        Rating rating = this.ratings.get("user");
        if (rating == null) {
            rating = this.ratings.get("NFO");
        }
        if (rating == null) {
            rating = this.ratings.get("default");
        }
        if (rating == null && !this.ratings.isEmpty()) {
            rating = this.ratings.values().iterator().next();
        }
        if (rating == null) {
            rating = new Rating();
        }
        return rating;
    }

    public int getYear() {
        return this.year;
    }

    public void setIds(Map<String, Object> ids) {
        for (Map.Entry<String, Object> entry : ids.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            this.setId(entry.getKey(), entry.getValue());
            this.firePropertyChange(entry.getKey(), null, entry.getValue());
        }
    }

    public void setTitle(String newValue) {
        String oldValue = this.title;
        this.title = newValue == null ? "" : newValue.trim();
        this.firePropertyChange("title", oldValue, newValue);
    }

    public void setOriginalTitle(String newValue) {
        String oldValue = this.originalTitle;
        this.originalTitle = newValue == null ? "" : newValue.trim();
        this.firePropertyChange("originalTitle", oldValue, newValue);
    }

    public void setPlot(String newValue) {
        String oldValue = this.plot;
        this.plot = newValue == null ? "" : newValue.trim();
        this.firePropertyChange("plot", oldValue, newValue);
    }

    public void setPath(String newValue) {
        String oldValue = this.path;
        this.path = newValue;
        this.firePropertyChange("path", oldValue, newValue);
    }

    public void removeRating(String id) {
        Rating removedRating = this.ratings.remove(id);
        if (removedRating != null) {
            this.firePropertyChange("rating", null, this.ratings);
        }
    }

    public void clearRatings() {
        this.ratings.clear();
        this.firePropertyChange("rating", null, this.ratings);
    }

    public void setRatings(Map<String, Rating> newRatings) {
        Rating userRating = this.ratings.get("user");
        this.ratings.clear();
        for (Map.Entry<String, Rating> entry : newRatings.entrySet()) {
            this.setRating(entry.getValue());
        }
        if (userRating != null && !newRatings.containsKey("user")) {
            this.setRating(userRating);
        }
    }

    public void setRating(Rating rating) {
        if (rating != null && StringUtils.isNotBlank((CharSequence)rating.getId())) {
            this.ratings.put(rating.getId(), rating);
            this.firePropertyChange("rating", null, rating);
        }
    }

    public void setYear(int newValue) {
        int oldValue = this.year;
        this.year = newValue;
        this.firePropertyChange("year", oldValue, newValue);
    }

    public void setArtworkUrl(String url, MediaFileType type) {
        String oldValue = this.getArtworkUrl(type);
        switch (type) {
            case POSTER: 
            case FANART: 
            case BANNER: 
            case THUMB: 
            case CLEARART: 
            case DISC: 
            case LOGO: 
            case CLEARLOGO: 
            case CHARACTERART: 
            case KEYART: {
                if (StringUtils.isBlank((CharSequence)url)) {
                    this.artworkUrlMap.remove((Object)type);
                    break;
                }
                this.artworkUrlMap.put(type, url);
                break;
            }
            default: {
                return;
            }
        }
        this.firePropertyChange(type.name().toLowerCase(Locale.ROOT) + "Url", oldValue, url);
    }

    public String getArtworkUrl(MediaFileType type) {
        String url = this.artworkUrlMap.get((Object)type);
        return url == null ? "" : url;
    }

    public void removeArtworkUrl(MediaFileType type) {
        this.artworkUrlMap.remove((Object)type);
    }

    public Map<MediaFileType, String> getArtworkUrls() {
        return this.artworkUrlMap;
    }

    public void setArtwork(Path file, MediaFileType type) {
        List<MediaFile> images = this.getMediaFiles(type);
        MediaFile mediaFile = null;
        if (!images.isEmpty()) {
            mediaFile = images.get(0);
            mediaFile.setFile(file);
            mediaFile.gatherMediaInformation(true);
        } else {
            mediaFile = new MediaFile(file, type);
            mediaFile.gatherMediaInformation();
            this.addToMediaFiles(mediaFile);
        }
        this.firePropertyChange("mediaInformation", false, true);
    }

    public Map<MediaFileType, MediaFile> getArtworkMap() {
        HashMap<MediaFileType, MediaFile> artworkMap = new HashMap<MediaFileType, MediaFile>();
        List<MediaFile> mfs = this.getMediaFiles();
        for (MediaFile mf : mfs) {
            if (!mf.isGraphic() || artworkMap.containsKey((Object)mf.getType())) continue;
            artworkMap.put(mf.getType(), mf);
        }
        return artworkMap;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public String getDateAddedAsString() {
        if (this.dateAdded == null) {
            return "";
        }
        return TmmDateFormat.MEDIUM_DATE_SHORT_TIME_FORMAT.format(this.dateAdded);
    }

    public void setDateAdded(Date newValue) {
        Date oldValue = this.dateAdded;
        this.dateAdded = newValue;
        this.firePropertyChange("dateAdded", oldValue, newValue);
        this.firePropertyChange("dateAddedAsString", oldValue, newValue);
    }

    public void setDateAddedFromMediaFile(MediaFile mf) {
        try {
            Date modDat;
            Date creDat;
            BasicFileAttributes view = Files.readAttributes(mf.getFileAsPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (view.creationTime().toMillis() > 100000L && (creDat = new Date(view.creationTime().toMillis())).compareTo(this.dateAdded) < 0) {
                this.setDateAdded(creDat);
            }
            if (view.lastModifiedTime().toMillis() > 100000L && (modDat = new Date(view.lastModifiedTime().toMillis())).compareTo(this.dateAdded) < 0) {
                this.setDateAdded(modDat);
            }
        }
        catch (Exception ignored) {
            LOGGER.warn("could not read filedate: {}", (Throwable)ignored);
        }
    }

    public String getProductionCompany() {
        return this.productionCompany;
    }

    public void setProductionCompany(String newValue) {
        String oldValue = this.productionCompany;
        this.productionCompany = newValue;
        this.firePropertyChange("productionCompany", oldValue, newValue);
    }

    protected void setScraped(boolean newValue) {
        this.scraped = newValue;
        this.firePropertyChange("scraped", false, newValue);
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public void setNote(String newValue) {
        String oldValue = this.note;
        this.note = newValue;
        this.firePropertyChange("note", oldValue, newValue);
    }

    public String getNote() {
        return this.note;
    }

    public void setDuplicate() {
        this.duplicate = true;
    }

    public void clearDuplicate() {
        this.duplicate = false;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setId(String key, Object value) {
        String v = String.valueOf(value);
        if ("".equals(v) || "0".equals(v) || "null".equals(v)) {
            this.ids.remove(key);
        } else {
            this.ids.put(key, value);
        }
        this.firePropertyChange(key, null, value);
        if ("tmdb".equals(key) || "imdb".equals(key) || "tvdb".equals(key) || "trakt".equals(key)) {
            this.firePropertyChange(key + "Id", null, value);
        }
    }

    public void removeId(String key) {
        Object obj = this.ids.remove(key);
        if (obj != null) {
            this.firePropertyChange(key, obj, null);
        }
    }

    public Object getId(String key) {
        return this.ids.get(key);
    }

    public String getIdAsString(String key) {
        Object obj = this.ids.get(key);
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public int getIdAsInt(String key) {
        Object obj = this.ids.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse int: {}", (Object)e.getMessage());
            }
        }
        return 0;
    }

    public void addToMediaFiles(MediaFile mediaFile) {
        MediaFile oldMf;
        int i;
        this.readWriteLock.writeLock().lock();
        if (this.mediaFiles.contains(mediaFile) && (i = this.mediaFiles.indexOf(mediaFile)) >= 0 && (oldMf = this.mediaFiles.get(i)).getType() != mediaFile.getType()) {
            this.mediaFiles.remove(i);
        }
        if (!this.mediaFiles.contains(mediaFile)) {
            this.mediaFiles.add(mediaFile);
        }
        this.sortMediaFiles();
        this.readWriteLock.writeLock().unlock();
        this.firePropertyChange("mediaFiles", null, this.mediaFiles);
        this.fireAddedEventForMediaFile(mediaFile);
    }

    public void addToMediaFiles(List<MediaFile> mediaFiles) {
        for (MediaFile mediaFile : mediaFiles) {
            this.addToMediaFiles(mediaFile);
        }
    }

    private void fireAddedEventForMediaFile(MediaFile mediaFile) {
        switch (mediaFile.getType()) {
            case FANART: {
                this.firePropertyChange("fanart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case POSTER: {
                this.firePropertyChange("poster", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case BANNER: {
                this.firePropertyChange("banner", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case THUMB: {
                this.firePropertyChange("thumb", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CLEARART: {
                this.firePropertyChange("clearart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case DISC: {
                this.firePropertyChange("disc", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case LOGO: {
                this.firePropertyChange("logo", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CLEARLOGO: {
                this.firePropertyChange("clearlogo", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CHARACTERART: {
                this.firePropertyChange("characterart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case KEYART: {
                this.firePropertyChange("keyart", null, mediaFile.getPath());
                this.firePropertyChange("hasImages", false, true);
                break;
            }
        }
    }

    private void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        switch (mediaFile.getType()) {
            case FANART: {
                this.firePropertyChange("fanart", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case POSTER: {
                this.firePropertyChange("poster", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case BANNER: {
                this.firePropertyChange("banner", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case THUMB: {
                this.firePropertyChange("thumb", null, "");
                this.firePropertyChange("hasImages", true, false);
                break;
            }
            case CLEARART: {
                this.firePropertyChange("clearart", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case DISC: {
                this.firePropertyChange("disc", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case LOGO: {
                this.firePropertyChange("logo", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CLEARLOGO: {
                this.firePropertyChange("clearlogo", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case CHARACTERART: {
                this.firePropertyChange("characterart", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
            case KEYART: {
                this.firePropertyChange("keyart", null, "");
                this.firePropertyChange("hasImages", false, true);
                break;
            }
        }
    }

    public List<MediaFile> getMediaFiles() {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        this.readWriteLock.readLock().lock();
        try {
            mf.addAll(this.mediaFiles);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return mf;
    }

    public boolean hasMediaFiles() {
        return !this.mediaFiles.isEmpty();
    }

    public List<MediaFile> getMediaFiles(MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (!match) continue;
            mf.add(mediaFile);
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public MediaFile getBiggestMediaFile(MediaFileType ... types) {
        MediaFile mf = null;
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type) || mf != null && mediaFile.getFilesize() < mf.getFilesize()) continue;
                mf = mediaFile;
            }
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public MediaFile getNewestMediaFilesOfType(MediaFileType ... types) {
        MediaFile mf = null;
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type) || mf != null && mediaFile.getFiledate() < mf.getFiledate()) continue;
                mf = new MediaFile(mediaFile);
            }
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public List<MediaFile> getMediaFilesExceptType(MediaFileType ... types) {
        ArrayList<MediaFile> mf = new ArrayList<MediaFile>();
        this.readWriteLock.readLock().lock();
        for (MediaFile mediaFile : this.mediaFiles) {
            boolean match = false;
            for (MediaFileType type : types) {
                if (!mediaFile.getType().equals((Object)type)) continue;
                match = true;
            }
            if (match) continue;
            mf.add(mediaFile);
        }
        this.readWriteLock.readLock().unlock();
        return mf;
    }

    public void removeAllMediaFiles() {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>(this.mediaFiles);
        this.readWriteLock.writeLock().lock();
        for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
            this.mediaFiles.remove(i);
        }
        this.readWriteLock.writeLock().unlock();
        for (MediaFile mediaFile : changedMediafiles) {
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    public void removeFromMediaFiles(MediaFile mediaFile) {
        this.readWriteLock.writeLock().lock();
        try {
            this.mediaFiles.remove(mediaFile);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        this.firePropertyChange("mediaFiles", null, this.mediaFiles);
        this.fireRemoveEventForMediaFile(mediaFile);
    }

    public void removeAllMediaFilesExceptType(MediaFileType type) {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>();
        this.readWriteLock.writeLock().lock();
        for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
            MediaFile mediaFile = this.mediaFiles.get(i);
            if (mediaFile.getType().equals((Object)type)) continue;
            this.mediaFiles.remove(i);
            changedMediafiles.add(mediaFile);
        }
        this.readWriteLock.writeLock().unlock();
        for (MediaFile mediaFile : changedMediafiles) {
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    public void removeAllMediaFiles(MediaFileType type) {
        ArrayList<MediaFile> changedMediafiles = new ArrayList<MediaFile>();
        this.readWriteLock.writeLock().lock();
        for (int i = this.mediaFiles.size() - 1; i >= 0; --i) {
            MediaFile mediaFile = this.mediaFiles.get(i);
            if (!mediaFile.getType().equals((Object)type)) continue;
            this.mediaFiles.remove(i);
            changedMediafiles.add(mediaFile);
        }
        this.readWriteLock.writeLock().unlock();
        for (MediaFile mediaFile : changedMediafiles) {
            this.fireRemoveEventForMediaFile(mediaFile);
        }
    }

    public void updateMediaFilePath(Path oldPath, Path newPath) {
        this.readWriteLock.readLock().lock();
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>(this.mediaFiles);
        this.readWriteLock.readLock().unlock();
        for (MediaFile mf : mfs) {
            if (mf.isGraphic()) {
                ImageCache.invalidateCachedImage(mf);
            }
            mf.replacePathForRenamedFolder(oldPath, newPath);
        }
    }

    public void gatherMediaFileInformation(boolean force) {
        this.readWriteLock.readLock().lock();
        ArrayList<MediaFile> mfs = new ArrayList<MediaFile>(this.mediaFiles);
        this.readWriteLock.readLock().unlock();
        for (MediaFile mediaFile : mfs) {
            mediaFile.gatherMediaInformation(force);
        }
        this.firePropertyChange("mediaInformation", false, true);
    }

    public void fireEventForChangedMediaInformation() {
        this.firePropertyChange("mediaInformation", false, true);
    }

    public boolean isNewlyAdded() {
        return this.newlyAdded;
    }

    public void setNewlyAdded(boolean newValue) {
        boolean oldValue = this.newlyAdded;
        this.newlyAdded = newValue;
        this.firePropertyChange("newlyAdded", oldValue, newValue);
    }

    public abstract void saveToDb();

    public abstract void deleteFromDb();

    public abstract void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType var1);

    protected abstract Comparator<MediaFile> getMediaFileComparator();
}

