/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ITmmModule;

public class TmmModuleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmModuleManager.class);
    private static TmmModuleManager instance;
    private Set<ITmmModule> modules = new LinkedHashSet<ITmmModule>();

    private TmmModuleManager() {
    }

    public static TmmModuleManager getInstance() {
        if (instance == null) {
            instance = new TmmModuleManager();
        }
        return instance;
    }

    public void registerModule(ITmmModule module) {
        this.modules.add(module);
    }

    public void enableModule(ITmmModule module) throws Exception {
        if (!this.modules.contains(module)) {
            throw new Exception("module " + module.getModuleTitle() + " not registered");
        }
        module.startUp();
    }

    public void disableModule(ITmmModule module) throws Exception {
        if (!this.modules.contains(module)) {
            throw new Exception("module " + module.getModuleTitle() + " not registered");
        }
        module.shutDown();
    }

    public Set<ITmmModule> getModules() {
        return this.modules;
    }

    public void startUp() {
    }

    public void shutDown() {
        for (ITmmModule module : this.modules) {
            if (!module.isEnabled()) continue;
            try {
                module.shutDown();
            }
            catch (Exception e) {
                LOGGER.error("problem shutting down " + module.getModuleTitle() + ": " + e.getMessage());
            }
        }
    }

    public void initializeDatabase() {
        for (ITmmModule module : this.modules) {
            try {
                if (module.isEnabled()) {
                    module.shutDown();
                }
                module.initializeDatabase();
            }
            catch (Exception e) {
                LOGGER.error("problem shutting down " + module.getModuleTitle() + ": " + e.getMessage());
            }
        }
    }

    public void saveSettings() {
        Globals.settings.saveSettings();
        for (ITmmModule module : this.modules) {
            try {
                if (!module.isEnabled()) continue;
                module.saveSettings();
            }
            catch (Exception e) {
                LOGGER.error("saving settings " + module.getModuleTitle() + ": " + e.getMessage());
            }
        }
    }
}

