/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import org.tinymediamanager.scraper.entities.Certification;

public enum CertificationStyle {
    SHORT,
    MEDIUM,
    MEDIUM_FULL,
    LARGE,
    LARGE_FULL,
    TECHNICAL;


    public static String formatCertification(Certification cert, CertificationStyle style) {
        if (cert == Certification.UNKNOWN) {
            return "";
        }
        switch (style) {
            case SHORT: {
                return cert.getName();
            }
            case MEDIUM: {
                return cert.getCountry().getAlpha2() + ": " + cert.getName();
            }
            case MEDIUM_FULL: {
                return cert.getCountry().getName() + ": " + cert.getName();
            }
            case LARGE: {
                return Certification.generateCertificationStringWithAlternateNames((Certification)cert);
            }
            case LARGE_FULL: {
                return Certification.generateCertificationStringWithAlternateNames((Certification)cert, (boolean)true);
            }
            case TECHNICAL: {
                return cert.name();
            }
        }
        return "";
    }
}

