/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;

public class UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTasks.class);

    public static void performUpgradeTasksBeforeDatabaseLoading(String oldVersion) {
        String v = "" + oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "3";
        }
        if (StrgUtils.compareVersion((String)v, (String)"3.0.5") < 0) {
            LOGGER.info("Performing upgrade tasks to version 3.0.5");
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(Globals.CACHE_FOLDER, new String[0]));){
                for (Path path : stream) {
                    if (path.toFile().isDirectory()) continue;
                    Utils.deleteFileSafely(path);
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not clean up cache folder - {}", (Object)e.getMessage());
            }
        }
    }

    public static void performUpgradeTasksAfterDatabaseLoading(String oldVersion) {
        MovieList movieList = MovieList.getInstance();
        TvShowList tvShowList = TvShowList.getInstance();
        String v = "" + oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "3";
        }
        if (StrgUtils.compareVersion((String)v, (String)"3.0.0") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3");
            Iterator<MediaEntity> al = new ArrayList();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(Globals.BACKUP_FOLDER, new String[0]));){
                for (Path path : directoryStream) {
                    if (!path.getFileName().toString().matches("movies\\.db\\.\\d{4}\\-\\d{2}\\-\\d{2}\\.zip") && !path.getFileName().toString().matches("tvshows\\.db\\.\\d{4}\\-\\d{2}\\-\\d{2}\\.zip")) continue;
                    ((ArrayList)((Object)al)).add((MediaEntity)((Object)path));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Iterator iterator = ((ArrayList)((Object)al)).iterator();
            while (iterator.hasNext()) {
                Iterator<TvShowEpisode> path = (Path)iterator.next();
                Utils.deleteFileSafely((Path)((Object)path));
            }
            if (MovieSettings.getInstance().getRenamerColonReplacement().equals("")) {
                MovieSettings.getInstance().setRenamerColonReplacement(" ");
                MovieSettings.getInstance().saveSettings();
            }
            if (TvShowSettings.getInstance().getRenamerColonReplacement().equals("")) {
                TvShowSettings.getInstance().setRenamerColonReplacement(" ");
                TvShowSettings.getInstance().saveSettings();
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"3.0.1") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.1");
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                if (!tvShow.getIds().containsKey("tvShowSeason")) continue;
                tvShow.removeId("tvShowSeason");
                tvShow.saveToDb();
            }
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    if (!tvShowEpisode.getArtworkUrl(MediaFileType.THUMB).equals("http://thetvdb.com/banners/")) continue;
                    tvShowEpisode.setArtworkUrl("", MediaFileType.THUMB);
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"3.0.2") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.2");
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    if (tvShowEpisode.getYear() != 0 || tvShowEpisode.getFirstAired() == null) continue;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(tvShowEpisode.getFirstAired());
                    tvShowEpisode.setYear(calendar.get(1));
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"3.0.3") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.3");
            for (Movie movie : MovieList.getInstance().getMovies()) {
                boolean dirty = false;
                for (MediaFile mf : movie.getMediaFiles()) {
                    for (MediaFileAudioStream as : mf.getAudioStreams()) {
                        if (!as.defaultStream || as.isDefaultStream()) continue;
                        as.setDefaultStream(true);
                        dirty = true;
                    }
                    for (MediaFileSubtitle sub : mf.getSubtitles()) {
                        if (sub.defaultStream && !sub.isDefaultStream()) {
                            sub.setDefaultStream(true);
                            dirty = true;
                        }
                        if (!sub.forced || sub.isForced()) continue;
                        sub.setForced(true);
                        dirty = true;
                    }
                }
                if (!dirty) continue;
                movie.saveToDb();
            }
            for (TvShow tvShow : TvShowList.getInstance().getTvShows()) {
                for (TvShowEpisode tvShowEpisode : tvShow.getEpisodes()) {
                    boolean dirty = false;
                    for (MediaFile mf : tvShowEpisode.getMediaFiles()) {
                        for (MediaFileAudioStream as : mf.getAudioStreams()) {
                            if (!as.defaultStream || as.isDefaultStream()) continue;
                            as.setDefaultStream(true);
                            dirty = true;
                        }
                        for (MediaFileSubtitle sub : mf.getSubtitles()) {
                            if (sub.defaultStream && !sub.isDefaultStream()) {
                                sub.setDefaultStream(true);
                                dirty = true;
                            }
                            if (!sub.forced || sub.isForced()) continue;
                            sub.setForced(true);
                            dirty = true;
                        }
                    }
                    if (!dirty) continue;
                    tvShowEpisode.saveToDb();
                }
            }
        }
        if (StrgUtils.compareVersion((String)v, (String)"3.0.4") < 0) {
            LOGGER.info("Performing database upgrade tasks to version 3.0.4");
            ImageCache.migrate();
            boolean alreadyMigrated = false;
            for (String entry : Settings.getInstance().getCleanupFileType()) {
                if (!entry.endsWith("$")) continue;
                alreadyMigrated = true;
                break;
            }
            if (!alreadyMigrated) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : Settings.getInstance().getCleanupFileType()) {
                    arrayList.add(string + "$");
                }
                Settings.getInstance().setCleanupFileTypes(arrayList);
            }
        }
    }

    public static void renameDownloadedFiles() {
        File cur;
        File file = new File("getdown-new.jar");
        if (file.exists() && file.length() > 100000L) {
            cur = new File("getdown.jar");
            if (file.length() != cur.length() || !cur.exists()) {
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update the updater!");
                }
            }
        }
        if (Platform.isWindows()) {
            file = new File("tinyMediaManager.new");
            if (file.exists() && file.length() > 10000L && file.length() < 100000L) {
                cur = new File("tinyMediaManager.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update tmm!");
                }
            }
            if ((file = new File("tinyMediaManagerUpd.new")).exists() && file.length() > 10000L && file.length() < 100000L) {
                cur = new File("tinyMediaManagerUpd.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update the updater!");
                }
            }
            if ((file = new File("tinyMediaManagerCMD.new")).exists() && file.length() > 10000L && file.length() < 100000L) {
                cur = new File("tinyMediaManagerCMD.exe");
                try {
                    FileUtils.copyFile((File)file, (File)cur);
                }
                catch (IOException e) {
                    LOGGER.error("Could not update CMD TMM!");
                }
            }
        }
        if (Platform.isMac() && (file = new File("JavaApplicationStub.new")).exists() && file.length() > 0L) {
            cur = new File("../../MacOS/JavaApplicationStub");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update JavaApplicationStub");
            }
        }
        if (Platform.isMac() && (file = new File("Info.plist")).exists() && file.length() > 0L) {
            cur = new File("../../Info.plist");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update JavaApplicationStub");
            }
        }
        if (Platform.isMac() && (file = new File("tmm.icns")).exists() && file.length() > 0L) {
            cur = new File("../tmm.icns");
            try {
                FileUtils.copyFile((File)file, (File)cur);
            }
            catch (IOException e) {
                LOGGER.error("Could not update tmm.icns");
            }
        }
    }
}

