/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryAppender.class);
    private int arraySize = 10000;
    private ArrayList<ILoggingEvent> loggingEvents;
    private Encoder<ILoggingEvent> encoder;

    public void start() {
        if (this.arraySize <= 0) {
            this.addError("an array size of 0 or lower is not allowed for [\"" + this.name + "\"].");
            return;
        }
        if (this.encoder == null) {
            this.addError("No encoder set for the appender named [\"" + this.name + "\"].");
            return;
        }
        this.loggingEvents = new ArrayList(this.arraySize);
        super.start();
    }

    public void stop() {
        this.loggingEvents.clear();
        super.stop();
        this.loggingEvents = null;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public void setSize(int size) {
        this.arraySize = size;
    }

    protected void append(ILoggingEvent e) {
        this.loggingEvents.add(e);
        if (this.loggingEvents.size() > this.arraySize && this.arraySize > 0) {
            this.loggingEvents.remove(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLog() {
        ArrayList<ILoggingEvent> clone = new ArrayList<ILoggingEvent>(this.loggingEvents);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (ILoggingEvent event : clone) {
                out.write(this.encoder.encode((Object)event));
            }
            String string = out.toString();
            return string;
        }
        catch (IOException e) {
            LOGGER.error("could not write trace logging: {}", (Object)e.getMessage());
            return "";
        }
    }
}

