/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath.loader;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.ClassPathManager;
import net.xeoh.plugins.base.impl.classpath.loader.AbstractLoader;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.ClassPathLocator;
import net.xeoh.plugins.base.impl.classpath.locator.locations.JARClasspathLocation;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLoader
extends AbstractLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLoader.class);

    public FileLoader(PluginManagerImpl pluginManager) {
        super(pluginManager);
    }

    public boolean handlesURI(URI uri) {
        return uri != null && "file".equals(uri.getScheme());
    }

    public void loadFrom(URI url, AddPluginsFromOption[] options) {
        if (url.getScheme().equals("file")) {
            LOGGER.debug("More specifically, trying to add from {}", (Object)url);
            try {
                File root = FileLoader.toFile(url.toURL());
                if (root == null || !root.exists()) {
                    this.logger.warning("Supplied path does not exist. Unable to add plugins from there.");
                    return;
                }
                this.locateAllPluginsAt(root);
            }
            catch (Exception e) {
                LOGGER.error("could not load plugins: {}", (Object)e.getMessage());
            }
        }
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuilder result = new StringBuilder(len);
        for (int i = 0; i < 4; ++i) {
            if (i < len && result.length() <= 0 && path.charAt(i) == '/') continue;
            result.append('/');
        }
        result.append(path);
        return result.toString();
    }

    private static File toFile(URL url) {
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            return null;
        }
        String externalForm = url.toExternalForm();
        String pathString = externalForm.substring(5);
        try {
            if (pathString.indexOf(47) == 0) {
                if (pathString.indexOf("//") == 0) {
                    externalForm = "file:" + FileLoader.ensureUNCPath(pathString);
                }
                return new File(new URI(externalForm));
            }
            if (pathString.indexOf(58) == 1) {
                return new File(new URI("file:/" + pathString));
            }
            return new File(new URI(pathString).getSchemeSpecificPart());
        }
        catch (Exception e) {
            return new File(pathString);
        }
    }

    void locateAllPluginsAt(File root) {
        ClassPathManager manager = this.pluginManager.getClassPathManager();
        ClassPathLocator locator = manager.getLocator();
        Collection locations = locator.findBelow(root.toURI());
        for (AbstractClassPathLocation location : locations) {
            manager.registerLocation(location);
            Collection<String> subclasses = null;
            if (location instanceof JARClasspathLocation) {
                JARClasspathLocation jarLocation = (JARClasspathLocation)location;
                subclasses = jarLocation.getPredefinedPluginList();
            }
            if (subclasses == null) {
                subclasses = manager.findSubclassesFor(location, Plugin.class);
            }
            for (String string : subclasses) {
                this.tryToLoadClassAsPlugin(location, string);
            }
        }
    }
}

