/*
 * Decompiled with CFR 0.152.
 */
package net.xeoh.plugins.base.impl.classpath;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.xeoh.plugins.base.impl.PluginManagerImpl;
import net.xeoh.plugins.base.impl.classpath.cache.JARCache;
import net.xeoh.plugins.base.impl.classpath.loader.AbstractLoader;
import net.xeoh.plugins.base.impl.classpath.loader.FileLoader;
import net.xeoh.plugins.base.impl.classpath.loader.HTTPLoader;
import net.xeoh.plugins.base.impl.classpath.loader.InternalClasspathLoader;
import net.xeoh.plugins.base.impl.classpath.locator.AbstractClassPathLocation;
import net.xeoh.plugins.base.impl.classpath.locator.ClassPathLocator;
import net.xeoh.plugins.base.impl.classpath.locator.locations.JARClasspathLocation;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

public class ClassPathManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Lock cacheLock = new ReentrantLock();
    private final JARCache jarCache = new JARCache();
    private final ClassPathLocator locator;
    private final Collection<AbstractLoader> pluginLoader = new ArrayList<AbstractLoader>();
    ClassWorld classWorld;
    boolean initializedProperly = false;

    public ClassPathManager(PluginManagerImpl pluginManager) {
        this.locator = new ClassPathLocator(pluginManager, this.jarCache);
        this.pluginLoader.add((AbstractLoader)new InternalClasspathLoader(pluginManager));
        this.pluginLoader.add(new FileLoader(pluginManager));
        this.pluginLoader.add((AbstractLoader)new HTTPLoader(pluginManager));
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    ClassPathManager.this.classWorld = new ClassWorld();
                    try {
                        ClassPathManager.this.classWorld.newRealm("core", this.getClass().getClassLoader());
                    }
                    catch (DuplicateRealmException e) {
                        e.printStackTrace();
                    }
                    ClassPathManager.this.initializedProperly = true;
                }
                catch (SecurityException e) {
                    ClassPathManager.this.logger.warning("Proper initialization failed due to security restrictions. Only classpath://xxx URIs will work. Sorry.");
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFromLocation(URI location, AddPluginsFromOption[] options) {
        if (location == null) {
            return false;
        }
        this.cacheLock.lock();
        try {
            this.jarCache.loadCache();
            for (AbstractLoader loader : this.pluginLoader) {
                if (!loader.handlesURI(location)) continue;
                loader.loadFrom(location, options);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.jarCache.saveCache();
            this.cacheLock.unlock();
        }
        return false;
    }

    public Class<?> loadClass(AbstractClassPathLocation location, String name) throws ClassNotFoundException {
        if (location == null) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        try {
            if (this.initializedProperly) {
                ClassLoader classLoader = this.classWorld.getRealm(location.getRealm()).getClassLoader();
                return classLoader.loadClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (NoSuchRealmException e) {
            e.printStackTrace();
        }
        return this.getClass().getClassLoader().loadClass(name);
    }

    public Collection<String> findSubclassesFor(AbstractClassPathLocation location, Class<?> superclass) {
        Collection collection;
        ArrayList<String> rval = new ArrayList<String>();
        if (!this.initializedProperly) {
            return rval;
        }
        JARCache.JARInformation cacheEntry = null;
        if (location instanceof JARClasspathLocation && (cacheEntry = ((JARClasspathLocation)location).getCacheEntry()) != null && (collection = (Collection)cacheEntry.subclasses.get(superclass.getCanonicalName())) != null) {
            return collection;
        }
        try {
            ClassLoader classLoader = this.classWorld.getRealm(location.getRealm()).getClassLoader();
            Collection listClassNames = location.listToplevelClassNames();
            for (String name : listClassNames) {
                Throwable cause;
                try {
                    Class<?> c = Class.forName(name, false, classLoader);
                    if (c.isInterface() || !superclass.isAssignableFrom(c) || superclass.getCanonicalName().equals(c.getCanonicalName())) continue;
                    rval.add(name);
                }
                catch (ClassNotFoundException e) {
                    this.logger.fine("ClassNotFoundException. Unable to inspect class " + name + " although it appears to be one.");
                    for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        this.logger.fine("Reason " + cause.getMessage());
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.logger.finer("Ignored class " + name + " due to unresolved dependencies");
                    for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        this.logger.fine("Reason " + cause.getMessage());
                    }
                }
                catch (SecurityException e) {
                    this.logger.fine("SecurityException while trying to find subclasses. Cause of trouble: " + name + ". This does not neccessarily mean problems however.");
                    for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        this.logger.fine("Reason " + cause.getMessage());
                    }
                }
                catch (Exception e) {
                    this.logger.finer("Ignored class " + name + " due to some other error");
                    for (cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        this.logger.fine("Reason " + cause.getMessage());
                    }
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                }
            }
        }
        catch (NoSuchRealmException e1) {
            e1.printStackTrace();
        }
        if (cacheEntry != null) {
            cacheEntry.subclasses.put(superclass.getCanonicalName(), rval);
        }
        return rval;
    }

    public void registerLocation(AbstractClassPathLocation location) {
        if (!this.initializedProperly) {
            return;
        }
        try {
            URI[] classpathLocations;
            ClassRealm newRealm = this.classWorld.newRealm(location.getRealm(), this.getClass().getClassLoader());
            for (URI uri : classpathLocations = location.getClasspathLocations()) {
                newRealm.addConstituent(uri.toURL());
            }
        }
        catch (DuplicateRealmException newRealm) {
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public InputStream getResourceAsStream(AbstractClassPathLocation location, String name) {
        if (location == null) {
            return this.getClass().getClassLoader().getResourceAsStream(name);
        }
        try {
            ClassLoader classLoader = this.classWorld.getRealm(location.getRealm()).getClassLoader();
            return classLoader.getResourceAsStream(name);
        }
        catch (NoSuchRealmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ClassPathLocator getLocator() {
        return this.locator;
    }

    public JARCache getCache() {
        return this.jarCache;
    }
}

